﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class DeaMap
    {
        public static async Task<IQueryable<DEA>> MapDea(List<ppms_deascheduleprivilege> ppmsDEAs, string mapRelatedType, PpmsContext context)
        {
            var DeaList = new List<DEA> { };
            foreach (var ppmsDea in ppmsDEAs) {
                var Dea = new DEA { };

                Dea.DeaNumber = Int32.Parse(ppmsDea.ppms_deanumber);
                Dea.Verifier = ppmsDea.ppms_verifier;
                if (ppmsDea.ppms_verificationdate != null)
                {
                    Dea.VerificationDate = ppmsDea.ppms_verificationdate.Value;
                }
                if (ppmsDea.ppms_expirationdate != null)
                {
                    Dea.ExpirationDate = ppmsDea.ppms_expirationdate.Value;
                }
                if (ppmsDea.ppms_associatedlocation != null)
                {
                    Dea.AssociatedLocationName = ppmsDea.ppms_associatedlocation.Name;
                }
                Dea.HasSchedule2 = ppmsDea.ppms_hasscheduleii.Value;
                Dea.HasSchedule2NonNarcotic = ppmsDea.ppms_hasscheduleiinonnarcotic.Value;
                Dea.HasSchedule3 = ppmsDea.ppms_hasscheduleiii.Value;
                Dea.HasSchedule3NonNarcotic = ppmsDea.ppms_hasscheduleiiinonnarcotic.Value;
                Dea.HasSchedule4 = ppmsDea.ppms_hasscheduleiv.Value;
                Dea.HasSchedule5 = ppmsDea.ppms_hasschedulev.Value;

                DeaList.Add(Dea);
            }
            return DeaList.AsQueryable();
        }      
    }
}